<?php

require_once __DIR__ . '/../src/AuthController.php';

$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

// Limitar la tasa de solicitudes (rate limiting)
// Asegúrate de implementar un sistema adecuado para rate limiting
$requestsPerMinute = 60;  // Máximo de solicitudes permitidas por minuto (esto debe implementarse con un contador por IP o usuario)

// Asegúrate de ajustar la URI según tu configuración de Apache y la estructura de carpetas
if ($method === 'POST') {
    // Obtener los datos enviados en la solicitud
    $data = json_decode(file_get_contents('php://input'), true);
    
    // Aquí podrías implementar un contador de solicitudes basado en la IP o el token, para aplicar la limitación
    // Ejemplo simple para limitar las solicitudes (esto debería implementarse con más detalle y en un sistema real):
    if ($requestsPerMinute > 60) {
        echo Response::json(['success' => false, 'message' => 'Demasiadas solicitudes, inténtelo más tarde'], 429);
        exit;
    }

    $authController = new AuthController();

// Ruta para login
if ($uri === '/ApiM/public/login' || $uri === '/ApiM/public/index.php/login') {
    echo $authController->login($data);
}
// Ruta para guardar la contraseña nueva
elseif ($uri === '/ApiM/public/updateUser' || $uri === '/ApiM/public/index.php/updateUser') {
    echo $authController->updateUser($data);
}

elseif ($uri === '/ApiM/public/getOperarioDatosConversacion' || $uri === '/ApiM/public/index.php/getOperarioDatosConversacion') {
    echo $authController->getOperarioDatosConversacion($data);
}

elseif ($uri === '/ApiM/public/getUsuariosGrupo' || $uri === '/ApiM/public/index.php/getUsuariosGrupo') {
    echo $authController->getUsuariosGrupo($data);
}
// Ruta para guardar la contraseña nueva en el pannel de admin
elseif ($uri === '/ApiM/public/updateUserA' || $uri === '/ApiM/public/index.php/updateUserA') {
    echo $authController->updateUserA($data);
}
// Ruta para guardar las notificaciones del usuario 
elseif ($uri === '/ApiM/public/actualizarNumeroNotificaciones' || $uri === '/ApiM/public/index.php/actualizarNumeroNotificaciones') {
    echo $authController->actualizarNumeroNotificaciones($data);
}

elseif ($uri === '/ApiM/public/getHorasCompensadas' || $uri === '/ApiM/public/index.php/getHorasCompensadas') {
    echo $authController->getHorasCompensadas($data);
}


elseif ($uri === '/ApiM/public/getRequestedVacationsPerNumTipo5' || $uri === '/ApiM/public/index.php/getRequestedVacationsPerNumTipo5') {
    echo $authController->getRequestedVacationsPerNumTipo5($data);
}


elseif ($uri === '/ApiM/public/getVacationTypes' || $uri === '/ApiM/public/index.php/getVacationTypes') {
    echo $authController->getVacationTypes($data);
}

// Ruta para enviar el token de recuperacion de email
elseif ($uri === '/ApiM/public/requestPasswordReset' || $uri === '/ApiM/public/index.php/requestPasswordReset') {
    echo $authController->requestPasswordReset($data);
}
// Ruta para cambiar estado de habilitar en la web
elseif ($uri === '/ApiM/public/updateUserStatus' || $uri === '/ApiM/public/index.php/updateUserStatus') {
    echo $authController->updateUserStatus($data);
}
// Ruta para actualizar contraseña recuperacion
elseif ($uri === '/ApiM/public/resetPassword' || $uri === '/ApiM/public/index.php/resetPassword') {
    echo $authController->resetPassword($data);
}
// Ruta para obtener detalles de usuario
elseif ($uri === '/ApiM/public/getUserDetails' || $uri === '/ApiM/public/index.php/getUserDetails') {
    echo $authController->getUserDetails($data);
}
// Ruta para obtener vacaciones confirmadas
elseif ($uri === '/ApiM/public/getConfirmedVacations' || $uri === '/ApiM/public/index.php/getConfirmedVacations') {
    echo $authController->getConfirmedVacations($data);
}
elseif ($uri === '/ApiM/public/getRemainingDays' || $uri === '/ApiM/public/index.php/getRemainingDays') {
    echo $authController->getRemainingDays($data);
}
elseif ($uri === '/ApiM/public/comprobarFechasVacaciones' || $uri === '/ApiM/public/index.php/comprobarFechasVacaciones') {
    echo $authController->comprobarFechasVacaciones($data);
}
elseif ($uri === '/ApiM/public/guardarSolicitudVacaciones' || $uri === '/ApiM/public/index.php/guardarSolicitudVacaciones') {
    echo $authController->guardarSolicitudVacaciones($data);
}

// Ruta para obtener resumen de vacaciones
elseif ($uri === '/ApiM/public/getVacationSummary' || $uri === '/ApiM/public/index.php/getVacationSummary') {
    echo $authController->getVacationSummary($data);
}

// Ruta para obtener resumen de vacaciones
elseif ($uri === '/ApiM/public/subirBaja' || $uri === '/ApiM/public/index.php/subirBaja') {
    echo $authController->subirBaja($data);
}
// Ruta para obtener resumen de vacaciones
elseif ($uri === '/ApiM/public/comprobarVacacionesPorFecha' || $uri === '/ApiM/public/index.php/comprobarVacacionesPorFecha') {
    echo $authController->comprobarVacacionesPorFecha($data);
}

// Ruta para obtener el contador de días de enfermedad en el año actual
elseif ($uri === '/ApiM/public/getCountDiasEnfermedad' || $uri === '/ApiM/public/index.php/getCountDiasEnfermedad') {
    echo $authController->getCountDiasEnfermedad($data);
}
// Ruta para verificar solapamientos con otras licencias o vacaciones
elseif ($uri === '/ApiM/public/checkSolapamientosLicencias' || $uri === '/ApiM/public/index.php/checkSolapamientosLicencias') {
    echo $authController->checkSolapamientosLicencias($data);
}
// Ruta para obtener el listado cronológico de licencias
elseif ($uri === '/ApiM/public/getLicenciasCronologicas' || $uri === '/ApiM/public/index.php/getLicenciasCronologicas') {
    echo $authController->getLicenciasCronologicas($data);
}
// Ruta para obtener licencias confirmadas
elseif ($uri === '/ApiM/public/getConfirmedLicens' || $uri === '/ApiM/public/index.php/getConfirmedLicens') {
    echo $authController->getConfirmedLicens($data);
}

// Ruta para guardarLicencia
elseif ($uri === '/ApiM/public/guardarLicencia' || $uri === '/ApiM/public/index.php/guardarLicencia') {
    echo $authController->guardarLicencia($data);
}

// Ruta para eliminarVacacionesSinConfirmar
elseif ($uri === '/ApiM/public/eliminarVacacionesSinConfirmar' || $uri === '/ApiM/public/index.php/eliminarVacacionesSinConfirmar') {
    echo $authController->eliminarVacacionesSinConfirmar($data);
}
// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/ApiM/public/listUsers' || $uri === '/ApiM/public/index.php/listUsers') {
    echo $authController->listUsers($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/ApiM/public/comprobarFechasLicencia' || $uri === '/ApiM/public/index.php/comprobarFechasLicencia') {
    echo $authController->comprobarFechasLicencia($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/ApiM/public/getRequestedVacationsPerNum' || $uri === '/ApiM/public/index.php/getRequestedVacationsPerNum') {
    echo $authController->getRequestedVacationsPerNum($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/ApiM/public/getConfirmedVacationsPerNum' || $uri === '/ApiM/public/index.php/getConfirmedVacationsPerNum') {
    echo $authController->getConfirmedVacationsPerNum($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/ApiM/public/getUserByAdmin' || $uri === '/ApiM/public/index.php/getUserByAdmin') {
    echo $authController->getUserByAdmin($data);
}

// Ruta para obtener el Vacaciones NO disfrutadas 
elseif ($uri === '/ApiM/public/getConfirmedButNotTakenVacations' || $uri === '/ApiM/public/index.php/getConfirmedButNotTakenVacations') {
    echo $authController->getConfirmedButNotTakenVacations($data);
}

// Ruta para borrar Vacaciones Solicitadas via web pero que no estan confirmadas
elseif ($uri === '/ApiM/public/deleteSolicitadasVacation' || $uri === '/ApiM/public/index.php/deleteSolicitadasVacation') {
    echo $authController->deleteSolicitadasVacation($data);
}

elseif ($uri === '/ApiM/public/getConfirmedLicensAdmin' || $uri === '/ApiM/public/index.php/getConfirmedLicensAdmin') {
    echo $authController->getConfirmedLicensAdmin($data);
}

elseif ($uri === '/ApiM/public/getVacationSummaryAdmin' || $uri === '/ApiM/public/index.php/getVacationSummaryAdmin') {
    echo $authController->getVacationSummaryAdmin($data);
}

elseif ($uri === '/ApiM/public/getUserByPerCodGes' || $uri === '/ApiM/public/index.php/getUserByPerCodGes') {
    echo $authController->getUserByPerCodGes($data);
}

// Ruta para borrar Vacaciones No disfrutadas pero que no estan confirmadas
elseif ($uri === '/ApiM/public/deleteConfirmedVacation' || $uri === '/ApiM/public/index.php/deleteConfirmedVacation') {
    echo $authController->deleteConfirmedVacation($data);
}

elseif ($uri === '/ApiM/public/getHorasComplementarias' || $uri === '/ApiM/public/index.php/getHorasComplementarias') {
    echo $authController->getHorasComplementarias($data);
}

// Ruta para borrar Vacaciones No disfrutadas pero que no estan confirmadas
elseif ($uri === '/ApiM/public/getLicenseDetails' || $uri === '/ApiM/public/index.php/getLicenseDetails') {
    echo $authController->getLicenseDetails($data);
}

// Ruta para borrar Vacaciones No disfrutadas pero que no estan confirmadas
elseif ($uri === '/ApiM/public/deleteLicense' || $uri === '/ApiM/public/index.php/deleteLicense') {
    echo $authController->deleteLicense($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/ApiM/public/getUserByPerNum' || $uri === '/ApiM/public/index.php/getUserByPerNum') {
    echo $authController->getUserByPerNum($data);
}

// Ruta para obtener vacaciones solicitadas
elseif ($uri === '/ApiM/public/getRequestedVacations' || $uri === '/ApiM/public/index.php/getRequestedVacations') {
    echo $authController->getRequestedVacations($data);
}
// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/ApiM/public/getOperarioNumber' || $uri === '/ApiM/public/index.php/getOperarioNumber') {
    echo $authController->getOperarioNumber($data);
}
else {
    echo Response::json(['success' => false, 'message' => 'Ruta no válida o método no soportado.'], 404);
}
} else {
    echo Response::json(['success' => false, 'message' => 'Método no soportado.'], 405);
}




