<?php

require_once __DIR__ . '/../src/AuthController.php';

$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

// Limitar la tasa de solicitudes (rate limiting)
// Asegúrate de implementar un sistema adecuado para rate limiting
$requestsPerMinute = 60;  // Máximo de solicitudes permitidas por minuto (esto debe implementarse con un contador por IP o usuario)

// Asegúrate de ajustar la URI según tu configuración de Apache y la estructura de carpetas
if ($method === 'POST') {
    // Obtener los datos enviados en la solicitud
    $data = json_decode(file_get_contents('php://input'), true);
    
    // Aquí podrías implementar un contador de solicitudes basado en la IP o el token, para aplicar la limitación
    // Ejemplo simple para limitar las solicitudes (esto debería implementarse con más detalle y en un sistema real):
    if ($requestsPerMinute > 60) {
        echo Response::json(['success' => false, 'message' => 'Demasiadas solicitudes, inténtelo más tarde'], 429);
        exit;
    }

    $authController = new AuthController();

// Ruta para login
if ($uri === '/APIE/public/login' || $uri === '/APIE/public/index.php/login') {
    echo $authController->login($data);
}
// Ruta para guardar la contraseña nueva
elseif ($uri === '/APIE/public/updateUser' || $uri === '/APIE/public/index.php/updateUser') {
    echo $authController->updateUser($data);
}
// Ruta para guardar la contraseña nueva en el pannel de admin
elseif ($uri === '/APIE/public/updateUserA' || $uri === '/APIE/public/index.php/updateUserA') {
    echo $authController->updateUserA($data);
}
// Ruta para guardar las notificaciones del usuario 
elseif ($uri === '/APIE/public/actualizarNumeroNotificaciones' || $uri === '/APIE/public/index.php/actualizarNumeroNotificaciones') {
    echo $authController->actualizarNumeroNotificaciones($data);
}

elseif ($uri === '/APIE/public/getVacationTypes' || $uri === '/APIE/public/index.php/getVacationTypes') {
    echo $authController->getVacationTypes($data);
}
elseif ($uri === '/APIE/public/listHolidays' || $uri === '/APIE/public/index.php/listHolidays') {
    echo $authController->listHolidays($data);
}

elseif ($uri === '/APIE/public/getConfirmedVacationsCalendar' || $uri === '/APIE/public/index.php/getConfirmedVacationsCalendar') {
    echo $authController->getConfirmedVacationsCalendar($data);
}

elseif ($uri === '/APIE/public/confirmarSolicitudVacaciones' || $uri === '/APIE/public/index.php/confirmarSolicitudVacaciones') {
    echo $authController->confirmarSolicitudVacaciones($data);
	
}

elseif ($uri === '/APIE/public/getRequestedVacationsCalendar' || $uri === '/APIE/public/index.php/getRequestedVacationsCalendar') {
    echo $authController->getRequestedVacationsCalendar($data);
	
}

elseif ($uri === '/APIE/public/rechazarSolicitudVacaciones' || $uri === '/APIE/public/index.php/rechazarSolicitudVacaciones') {
    echo $authController->rechazarSolicitudVacaciones($data);
	
}

elseif ($uri === '/APIE/public/deleteSolicitadasVacation' || $uri === '/APIE/public/index.php/deleteSolicitadasVacation') {
    echo $authController->deleteSolicitadasVacation($data);
	
}


// Ruta para enviar el token de recuperacion de email
elseif ($uri === '/APIE/public/requestPasswordReset' || $uri === '/APIE/public/index.php/requestPasswordReset') {
    echo $authController->requestPasswordReset($data);
}
// Ruta para cambiar estado de habilitar en la web
elseif ($uri === '/APIE/public/updateUserStatus' || $uri === '/APIE/public/index.php/updateUserStatus') {
    echo $authController->updateUserStatus($data);
}
// Ruta para actualizar contraseña recuperacion
elseif ($uri === '/APIE/public/resetPassword' || $uri === '/APIE/public/index.php/resetPassword') {
    echo $authController->resetPassword($data);
}
// Ruta para obtener detalles de usuario
elseif ($uri === '/APIE/public/getUserDetails' || $uri === '/APIE/public/index.php/getUserDetails') {
    echo $authController->getUserDetails($data);
}
// Ruta para obtener vacaciones confirmadas
elseif ($uri === '/APIE/public/getConfirmedVacations' || $uri === '/APIE/public/index.php/getConfirmedVacations') {
    echo $authController->getConfirmedVacations($data);
}
elseif ($uri === '/APIE/public/getRemainingDays' || $uri === '/APIE/public/index.php/getRemainingDays') {
    echo $authController->getRemainingDays($data);
}
elseif ($uri === '/APIE/public/comprobarFechasVacaciones' || $uri === '/APIE/public/index.php/comprobarFechasVacaciones') {
    echo $authController->comprobarFechasVacaciones($data);
}
elseif ($uri === '/APIE/public/guardarSolicitudVacaciones' || $uri === '/APIE/public/index.php/guardarSolicitudVacaciones') {
    echo $authController->guardarSolicitudVacaciones($data);
}

// Ruta para obtener resumen de vacaciones
elseif ($uri === '/APIE/public/getVacationSummary' || $uri === '/APIE/public/index.php/getVacationSummary') {
    echo $authController->getVacationSummary($data);
}

// Ruta para obtener resumen de vacaciones
elseif ($uri === '/APIE/public/subirBaja' || $uri === '/APIE/public/index.php/subirBaja') {
    echo $authController->subirBaja($data);
}
// Ruta para obtener resumen de vacaciones
elseif ($uri === '/APIE/public/comprobarVacacionesPorFecha' || $uri === '/APIE/public/index.php/comprobarVacacionesPorFecha') {
    echo $authController->comprobarVacacionesPorFecha($data);
}

// Ruta para obtener el contador de días de enfermedad en el año actual
elseif ($uri === '/APIE/public/getCountDiasEnfermedad' || $uri === '/APIE/public/index.php/getCountDiasEnfermedad') {
    echo $authController->getCountDiasEnfermedad($data);
}
// Ruta para verificar solapamientos con otras licencias o vacaciones
elseif ($uri === '/APIE/public/checkSolapamientosLicencias' || $uri === '/APIE/public/index.php/checkSolapamientosLicencias') {
    echo $authController->checkSolapamientosLicencias($data);
}
// Ruta para obtener el listado cronológico de licencias
elseif ($uri === '/APIE/public/getLicenciasCronologicas' || $uri === '/APIE/public/index.php/getLicenciasCronologicas') {
    echo $authController->getLicenciasCronologicas($data);
}
// Ruta para obtener licencias confirmadas
elseif ($uri === '/APIE/public/getConfirmedLicens' || $uri === '/APIE/public/index.php/getConfirmedLicens') {
    echo $authController->getConfirmedLicens($data);
}

// Ruta para guardarLicencia
elseif ($uri === '/APIE/public/guardarLicencia' || $uri === '/APIE/public/index.php/guardarLicencia') {
    echo $authController->guardarLicencia($data);
}

// Ruta para eliminarVacacionesSinConfirmar
elseif ($uri === '/APIE/public/eliminarVacacionesSinConfirmar' || $uri === '/APIE/public/index.php/eliminarVacacionesSinConfirmar') {
    echo $authController->eliminarVacacionesSinConfirmar($data);
}
// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/APIE/public/listUsers' || $uri === '/APIE/public/index.php/listUsers') {
    echo $authController->listUsers($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/APIE/public/comprobarFechasLicencia' || $uri === '/APIE/public/index.php/comprobarFechasLicencia') {
    echo $authController->comprobarFechasLicencia($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/APIE/public/getRequestedVacationsPerNum' || $uri === '/APIE/public/index.php/getRequestedVacationsPerNum') {
    echo $authController->getRequestedVacationsPerNum($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/APIE/public/getConfirmedVacationsPerNum' || $uri === '/APIE/public/index.php/getConfirmedVacationsPerNum') {
    echo $authController->getConfirmedVacationsPerNum($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/APIE/public/getUserByAdmin' || $uri === '/APIE/public/index.php/getUserByAdmin') {
    echo $authController->getUserByAdmin($data);
}

// Ruta para obtener el Vacaciones NO disfrutadas 
elseif ($uri === '/APIE/public/getConfirmedButNotTakenVacations' || $uri === '/APIE/public/index.php/getConfirmedButNotTakenVacations') {
    echo $authController->getConfirmedButNotTakenVacations($data);
}

// Ruta para borrar Vacaciones Solicitadas via web pero que no estan confirmadas
elseif ($uri === '/APIE/public/deleteSolicitadasVacation' || $uri === '/APIE/public/index.php/deleteSolicitadasVacation') {
    echo $authController->deleteSolicitadasVacation($data);
}

elseif ($uri === '/APIE/public/getConfirmedLicensAdmin' || $uri === '/APIE/public/index.php/getConfirmedLicensAdmin') {
    echo $authController->getConfirmedLicensAdmin($data);
}

elseif ($uri === '/APIE/public/getVacationSummaryAdmin' || $uri === '/APIE/public/index.php/getVacationSummaryAdmin') {
    echo $authController->getVacationSummaryAdmin($data);
}

elseif ($uri === '/APIE/public/getUserByPerCodGes' || $uri === '/APIE/public/index.php/getUserByPerCodGes') {
    echo $authController->getUserByPerCodGes($data);
}

// Ruta para borrar Vacaciones No disfrutadas pero que no estan confirmadas
elseif ($uri === '/APIE/public/deleteConfirmedVacation' || $uri === '/APIE/public/index.php/deleteConfirmedVacation') {
    echo $authController->deleteConfirmedVacation($data);
}

elseif ($uri === '/APIE/public/getHorasComplementarias' || $uri === '/APIE/public/index.php/getHorasComplementarias') {
    echo $authController->getHorasComplementarias($data);
}

// Ruta para borrar Vacaciones No disfrutadas pero que no estan confirmadas
elseif ($uri === '/APIE/public/getLicenseDetails' || $uri === '/APIE/public/index.php/getLicenseDetails') {
    echo $authController->getLicenseDetails($data);
}

// Ruta para borrar Vacaciones No disfrutadas pero que no estan confirmadas
elseif ($uri === '/APIE/public/deleteLicense' || $uri === '/APIE/public/index.php/deleteLicense') {
    echo $authController->deleteLicense($data);
}

// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/APIE/public/getUserByPerNum' || $uri === '/APIE/public/index.php/getUserByPerNum') {
    echo $authController->getUserByPerNum($data);
}

// Ruta para obtener vacaciones solicitadas
elseif ($uri === '/APIE/public/getRequestedVacations' || $uri === '/APIE/public/index.php/getRequestedVacations') {
    echo $authController->getRequestedVacations($data);
}
// Ruta para obtener el PER_NUM del usuario en sesión
elseif ($uri === '/APIE/public/getOperarioNumber' || $uri === '/APIE/public/index.php/getOperarioNumber') {
    echo $authController->getOperarioNumber($data);
}
else {
    echo Response::json(['success' => false, 'message' => 'Ruta no válida o método no soportado.'], 404);
}
} else {
    echo Response::json(['success' => false, 'message' => 'Método no soportado.'], 405);
}




