<?php
header('Content-Type: application/json');

$tipo = $_GET['tipo'] ?? null;
$valor = $_GET['valor'] ?? null;
$fecha = $_GET['fecha'] ?? null;

if (!$tipo || !$valor || !$fecha) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan parámetros']);
    exit;
}

if ($tipo === 'tarifa') {
    $url = "https://api.bicubo.es/v0.9/2c386520-358d-434a-a12f-2c6cfa5d31fd/costes/tarifa/{$valor}/dia/{$fecha}";
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Tipo no soportado']);
    exit;
}

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    http_response_code(500);
    echo json_encode(['error' => 'Error de conexión: ' . curl_error($ch)]);
    exit;
}

curl_close($ch);
echo $response;
?>
