<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php'; // PHPMailer desde Composer

$email = $_GET['email'] ?? $_POST['email'] ?? '';
$nombre = $_GET['nombre'] ?? $_POST['nombre'] ?? '';

// Validar
if (!$email || !$nombre) {
    die("Faltan datos para enviar la reseña.");
}


$mail = new PHPMailer(true);

try {
    // Configuración SMTP
    $mail->isSMTP();
    $mail->Host       = 'smtp.serviciodecorreo.es';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'atencionalcliente@elegaenergia.es';
    $mail->Password   = '1$Ad@*EnC&2';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port       = 465;

    // Cabeceras
    $mail->CharSet    = 'UTF-8';
    $mail->isHTML(true);
    $mail->Subject    = '¿Nos dejas una reseña sobre tu experiencia con Elega Energía?';
    $mail->AltBody    = "Hola $nombre,\nGracias por confiar en Elega Energía. ¿Nos dejas una reseña? https://www.google.com/search?q=Elega+Energ%C3%ADa+Rese%C3%B1as";

    // Remitente y destinatario
    $mail->setFrom('atencionalcliente@elegaenergia.es', 'Elega Energía');
    $mail->addAddress($email, $nombre);


    $mail->addEmbeddedImage(__DIR__ . '/img/logo.png', 'logoElega', 'logo.png');


$mail->addEmbeddedImage(
    __DIR__ . '/img/satisfacion.png',
    'imgSatisfacion',
    'satisfacion.png'
);



        $mail->Body = '
        <!DOCTYPE html>
        <html lang="es">
        <head><meta charset="UTF-8"></head>
        <body style="font-family: Segoe UI, sans-serif; background-color: #f5f5f5; margin: 0; padding: 20px;">
        <table style="max-width: 600px; margin: 0 auto; background: #fff; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.05);">
        <tr style="background-color: #003366;">
        <td style="padding: 20px; text-align: center;">
          <img src="cid:logoElega" width="120" alt="Elega Energía" style="margin: 0 auto; display: block;">
        </td>
      </tr>
      
            <td style="padding: 30px 20px 20px 20px; text-align: center;">
                <h2 style="color: #003366; margin-bottom: 10px;">¿Nos dejas una reseña sobre tu experiencia?</h2>
                <p style="font-size: 16px; color: #555; margin-bottom: 25px;">
                Hola <strong>' . htmlspecialchars($nombre) . '</strong>,<br><br>
                Queremos agradecerte por confiar en <strong>Elega Energía</strong>.<br>
                Si tuviste una buena experiencia, ¿nos ayudarías dejando una reseña en nuestra ficha de Google?
                </p>

                <img src="cid:imgSatisfacion" alt="Opinión Cliente"
                style="margin: 0 auto 20px auto; width: 40%; max-width: 200px; border-radius: 10px; display: block;">

                <a href="https://g.page/r/CcI-AA1r2AY7EBM/review"
                target="_blank"
                style="display: inline-block; margin-bottom: 20px; padding: 12px 24px; background-color: #28a745; color: white; text-decoration: none; border-radius: 6px; font-weight: bold;">
                ⭐ Dejar reseña en Google
                </a>

                <p style="font-size: 14px; color: #666;">Gracias por tu tiempo 😊</p>
                <p style="font-weight: bold; color: #333;">Equipo de Elega Energía</p>
            </td>
            </tr>
            <tr>
            <td style="background-color: #f0f0f0; padding: 15px; text-align: center; font-size: 12px; color: #888;">
                © ' . date("Y") . ' Elega Energía. Todos los derechos reservados.
            </td>
            </tr>
        </table>
        </body>
        </html>';


    // Enviar correo
    $mail->send();

    $origen = $_GET['origen'] ?? $_POST['origen'] ?? '';
    $destino = $origen === 'index' ? 'index.php' : 'ver_registros.php';
    header("Location: $destino?mensaje=reseña_enviada");
    exit;

} catch (Exception $e) {
    echo '❌ Error al enviar: ', $mail->ErrorInfo;
}
