<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Mi Entorno Elega | Herramientas y Accesos Energéticos</title>


    <link rel="icon" type="image/png" href="img/favi.png">


    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">


<style>
@keyframes parpadeo-visible {
  0%, 100% {
    box-shadow: 0 0 0px rgba(0, 123, 255, 0.3);
    transform: scale(1);
  }
  50% {
    box-shadow: 0 0 12px rgba(0, 123, 255, 0.8);
    transform: scale(1.08);
  }
}

.btn-parpadea {
  animation: parpadeo-visible 1.8s ease-in-out infinite;
}
</style>


</head>


<!-- AQUI aplicamos el fondo degradado -->
<body style="background: linear-gradient(90deg, #1371b7, #9ac355); min-height: 100vh;">



<div class="container mt-5">

<?php if (isset($_GET['guardado']) && $_GET['guardado'] === 'ok'): ?>
  <div id="alertaGuardado" class="alert alert-success alert-dismissible fade show text-center mt-3" role="alert">
    ✅ <strong>Registro guardado correctamente.</strong>
  </div>
<?php endif; ?>

<?php if (isset($_GET['mensaje']) && $_GET['mensaje'] === 'reseña_enviada'): ?>
  <div id="mensajeExito" class="alert alert-success text-center mt-3">
    📩 Correo de solicitud de reseña enviado correctamente al cliente.
  </div>
<?php endif; ?>



<h1 class="text-center mb-2 text-white">
  <i class="fas fa-tools me-2"></i> Mi Entorno Elega
</h1>
<p class="text-center text-white-50 fs-5 mb-5">
  Accede a todas tus herramientas, portales de gestión, informes y más, desde un solo lugar.<br>
  Tu centro de control energético con Elega Energía.
</p>



<a href="https://chat.openai.com/" target="_blank"
   class="btn btn-light shadow position-fixed top-0 end-0 m-3 rounded-circle btn-parpadea"
   style="right: 6.2rem !important; z-index: 1050;"
   title="ChatGPT gratuito">
  <i class="fas fa-robot fs-4 text-success"></i>
</a>

<!-- Botón flotante para registrar origen -->
<button class="btn btn-warning shadow position-fixed bottom-0 end-0 m-4 rounded-circle btn-parpadea"
        data-bs-toggle="modal" data-bs-target="#modalRegistrarOrigen"
        title="Registrar origen del cliente" style="z-index:1050;">
  <i class="fas fa-file-alt fs-4 text-dark"></i>
</button>

<!--C Botón flotante para enviar reseñas -->
<button class="btn btn-success shadow position-fixed bottom-0 start-0 m-4 rounded-circle btn-parpadea"
        data-bs-toggle="modal" data-bs-target="#modalEnviarResena"
        title="Enviar correo de reseña" style="z-index:1050;">
  <i class="fas fa-star fs-4 text-white"></i>
</button>



<button id="btnAccesosRapidos"
  class="btn btn-light shadow position-fixed top-0 end-0 m-3 rounded-circle btn-parpadea"
  title="Accesos rápidos"
  style="z-index: 1050;">
  <i class="fas fa-link fs-4 text-primary"></i>
</button>


    <div class="row g-4">

       <!-- 
        <div class="col-md-4">
            <a href="http://172.26.0.4/CosteBICUBO/costes.php" target="_blank" class="text-decoration-none">
                <div class="card h-100 shadow-sm text-center p-4">
                    <div class="mb-3">
                        <i class="fas fa-chart-line fa-3x text-primary"></i>
                    </div>
                    <h5 class="card-title">Coste por cups (BICUBO)</h5>
                    <p class="card-text">Consultar costes horarios a través del sistema BICUBO.</p>
                </div>
            </a>
        </div>
-->
        
        <div class="col-md-4">
            <a href="http://172.26.0.4/costetarifa/index.php" target="_blank" class="text-decoration-none">
                <div class="card h-100 shadow-sm text-center p-4">
                    <div class="mb-3">
                        <i class="fas fa-file-excel fa-3x text-success"></i>
                    </div>
                    <h5 class="card-title">Coste por Tarifa (BICUBO)</h5>
                    <p class="card-text">Generar Excel de tarifas seleccionando rango de fechas y tipo de tarifa.</p>
                </div>
            </a>
		</div>
			
			<div class="col-md-4">
  <a href="http://172.26.0.4/detalles_clientes/index.php" class="text-decoration-none" target="_blank" rel="noopener">
    <div class="card h-100 shadow-sm text-center p-4">
      <div class="mb-3">
        <i class="fas fa-brain fa-3x text-info"></i>
      </div>
      <h5 class="card-title">¿Cómo consumen nuestros clientes?</h5>
      <p class="card-text">Consulta el hábito de consumo de nuestros clientes.</p>
    </div>
  </a>
</div>

        <!-- Precio OMIE 
        <div class="col-md-4">
            <a href="http://172.26.0.4/precio_omie/index.php" target="_blank" class="text-decoration-none">
                <div class="card h-100 shadow-sm text-center p-4">
                    <div class="mb-3">
                        <i class="fas fa-euro-sign fa-3x text-warning"></i>
                    </div>
                    <h5 class="card-title">Precio OMIE</h5>
                    <p class="card-text">Consultar y descargar precios OMIE diarios y horarios.</p>
                </div>
            </a>
        </div>-->

        <!-- Informes Elega -->
<div class="col-md-4">
    <a href="http://172.26.0.4/InformesElega/public/login" class="text-decoration-none" target="_blank">
        <div class="card h-100 shadow-sm text-center p-4">
            <div class="mb-3">
                <i class="fas fa-file-alt fa-3x text-info"></i>
            </div>
            <h5 class="card-title">Informes Elega</h5>
            <p class="card-text">Accede a los informes internos y análisis de datos de Elega.</p>
        </div>
    </a>
</div>

<!-- Comparador de Tarifas -->
<div class="col-md-4">
    <a href="http://172.26.0.4/ComparadorTarifas/public/" class="text-decoration-none" target="_blank">
        <div class="card h-100 shadow-sm text-center p-4">
            <div class="mb-3">
                <i class="fas fa-balance-scale fa-3x text-danger"></i>
            </div>
            <h5 class="card-title">Compararador comercializadoras</h5>
            <p class="card-text">Comparar comercializadoras de energía consiste en evaluar las distintas ofertas de electricidad.</p>
        </div>
    </a>
</div>


<!-- Precios Electricidad (Maisenerxia) -->
<div class="col-md-4">
<a href="http://172.26.0.4/lector_precios/vista_grafica_mes.html" class="text-decoration-none" target="_blank">
        <div class="card h-100 shadow-sm text-center p-4">
            <div class="mb-3">
                <i class="fas fa-bolt fa-3x text-warning"></i>
            </div>
            <h5 class="card-title">Precios Electricidad (Maisenerxia)</h5>
            <p class="card-text">Últimos precios diarios por periodo.</p>
        </div>
    </a>
</div>

<div class="col-md-4">
    <a href="http://172.26.0.4/consumo-cups-php/index.php" class="text-decoration-none" target="_blank">
        <div class="card h-100 shadow-sm text-center p-4">
            <div class="mb-3">
                <i class="fas fa-chart-line fa-3x text-success"></i>
            </div>
            <h5 class="card-title">Curvas de Carga - Productos Fijos</h5>
            <p class="card-text">Descarga los consumos horarios de los productos fijos del Metering.</p>
        </div>
    </a>
</div>






    </div>

    <div class="container mt-5">
    <h2 class="text-center mb-4 text-white">Consultar Coste Energía por Fecha y Tarifa</h2>

    <div class="row justify-content-center mb-4">
        <div class="col-md-3 mb-3">
            <select id="tarifaSeleccionada" class="form-select text-center shadow-sm p-2 bg-white rounded" required>
                <option value="" selected disabled>Selecciona una Tarifa</option>
                <option value="2.0TD">2.0TD</option>
                <option value="3.0TD">3.0TD</option>
                <option value="6.1TD">6.1TD</option>
                <!-- Puedes añadir más tarifas si quieres -->
            </select>
        </div>
        <div class="col-md-3 mb-3">
            <input type="date" id="fechaSeleccionada" class="form-control text-center shadow-sm p-2 bg-white rounded" required>
        </div>
    </div>

    <!-- Info media, tarifa, periodo -->
    <div id="infoDia" class="text-center mb-4 text-white" style="display: none;">
        <h4 id="mediaPrecio"></h4>
    </div>

    <!-- Gráfica -->
    <div id="bloqueGrafica" style="width: 100%; max-width: 900px; margin: auto; display: none;">
        <canvas id="graficaCostes" style="background-color: white; border-radius: 10px;" width="800" height="400"></canvas>
    </div>
</div> 





</div>

</div>

<!-- Modal de accesos rápidos -->
<div class="modal fade" id="modalAccesosRapidos" tabindex="-1" aria-labelledby="accesosRapidosLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="accesosRapidosLabel"><i class="fas fa-link me-2"></i> Accesos Rápidos</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <div class="row g-3 text-center">
		
		  <div class="col-6 col-md-4">
    <a href="https://elegaenergia-tradeenergy.nemon2ib.com/login/" target="_blank" class="text-decoration-none text-dark">
      <div class="border rounded p-3 shadow-sm h-100">
        <div class="fs-2">💼</div>
        <div>TRADE Energía</div>
      </div>
    </a>
  </div>

  <div class="col-6 col-md-4">
    <a href="https://elegaenergia-crm.nemon2ib.com/login/" target="_blank" class="text-decoration-none text-dark">
      <div class="border rounded p-3 shadow-sm h-100">
        <div class="fs-2">📋</div>
        <div>TRADE CRM</div>
      </div>
    </a>
  </div>

  <div class="col-6 col-md-4">
    <a href="https://elegaenergia-customerweb.nemon2ib.com/login/" target="_blank" class="text-decoration-none text-dark">
      <div class="border rounded p-3 shadow-sm h-100">
        <div class="fs-2">👥</div>
        <div>TRADE Clientes</div>
      </div>
    </a>
  </div>
  
  <!-- Documentación / Guías (en Accesos Rápidos) -->
<div class="col-6 col-md-4">
  <a href="http://172.26.0.4/protocolos/index.php" target="_blank"
     class="text-decoration-none text-dark" title="Centro de Documentación">
    <div class="border rounded p-3 shadow-sm h-100">
      <div class="fs-2 mb-1">
        <!-- Icono documento grande -->
        <i class="fa-solid fa-file-lines text-primary"></i>
      </div>
      <div>Documentación</div>
      <small class="text-muted d-block">Guías y plantillas</small>
    </div>
  </a>
</div>



          <!-- Enlaces individuales -->
          <div class="col-6 col-md-4">
            <a href="https://www.elegaenergia.es/" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">🌐</div>
                <div>Web Corporativa</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
            <a href="https://ofertas.elegaenergia.es/" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">📢</div>
                <div>Landing Comercial</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
            <a href="https://mielegadashboard.portalmoneleg.es/login.html" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">📱</div>
                <div>Mi Elega (App) Incidencias</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
            <a href="https://play.google.com/store/search?q=mi%20elega&c=apps&hl=es" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">🤖</div>
                <div>Mi Elega (Android)</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
            <a href="https://apps.apple.com/es/app/mi-elega/id6747075388" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">🍏</div>
                <div>Mi Elega (iOS)</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
            <a href="https://virtual.portalelega.es/login" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">🧾</div>
                <div>Portal Virtual</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
            <a href="https://atenea.bicubo.es/login/" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">📊</div>
                <div>Atenea BICUBO</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
            <a href="https://datadis.es/login" target="_blank" class="text-decoration-none text-dark">
              <div class="border rounded p-3 shadow-sm h-100">
                <div class="fs-2">🔌</div>
                <div>Datadis</div>
              </div>
            </a>
          </div>

          <div class="col-6 col-md-4">
  <a href="ver_registros.php" target="_blank" class="text-decoration-none text-dark">
    <div class="border rounded p-3 shadow-sm h-100">
      <div class="fs-2">🧮</div>
      <div>Seguimiento / trazabilidad</div>
    </div>
  </a>
</div>


        </div>
      </div>
    </div>
  </div>
</div>


<!-- Modal registrar origen cliente -->
<div class="modal fade" id="modalRegistrarOrigen" tabindex="-1" aria-labelledby="modalOrigenLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-warning text-dark">
        <h5 class="modal-title" id="modalOrigenLabel">
          <i class="fas fa-file-alt me-2"></i> Registrar Origen del Cliente
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>

      <form action="guardar_origen.php" method="POST">
        <div class="modal-body">

          <div class="mb-3">
            <label class="form-label">Nombre</label>
            <input type="text" name="nombre" class="form-control" required placeholder="Ej. Laura Pérez">
          </div>

          <div class="mb-3">
            <label class="form-label">Teléfono</label>
            <input type="text" name="telefono" class="form-control" placeholder="Ej. 612345678">
          </div>

          <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control" placeholder="Ej. cliente@email.com">
          </div>

          <div class="mb-3">
            <label class="form-label">Origen del cliente</label>
            <select name="origen" class="form-select" required>
              <option value="">Seleccionar origen...</option>
              <option value="web">Web corporativa</option>
              <option value="landing">Landing comercial</option>
              <option value="redes">Redes sociales</option>
              <option value="app_android">App Android</option>
              <option value="app_ios">App iOS</option>
              <option value="recomendacion">Recomendación</option>
              <option value="otro">Otro</option>
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Canal secundario</label>
            <input type="text" name="canal_secundario" class="form-control" placeholder="Ej. WhatsApp, llamada, email...">
          </div>

          <div class="mb-3">
            <label class="form-label">Observaciones</label>
            <textarea name="observaciones" class="form-control" rows="2" placeholder="Anota cualquier dato adicional del contacto..."></textarea>
          </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar</button>
        </div>
      </form>
    </div>
  </div>
</div>


<!-- Modal Enviar Reseña -->
<div class="modal fade" id="modalEnviarResena" tabindex="-1" aria-labelledby="modalResenaLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title" id="modalResenaLabel">
          <i class="fas fa-star me-2"></i> Enviar Solicitud de Reseña
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>

      <form action="enviar_reseña.php" method="POST">
      <input type="hidden" name="origen" value="index">
        <div class="modal-body">

          <div class="mb-3">
            <label class="form-label">Nombre completo</label>
            <input type="text" name="nombre" class="form-control" placeholder="Ej. Laura Pérez" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Correo electrónico</label>
            <input type="email" name="email" class="form-control" placeholder="Ej. cliente@email.com" required>
          </div>

          <p class="text-muted small mt-3">
            Se enviará un correo automático con el texto de reseña configurado.
          </p>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Enviar Correo</button>
        </div>
      </form>
    </div>
  </div>
</div>








</body>



<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>


document.getElementById('btnAccesosRapidos').addEventListener('click', () => {
  const modal = new bootstrap.Modal(document.getElementById('modalAccesosRapidos'));
  modal.show();
});
//const urlBase = 'http://localhost/mientornoelega/api-proxy.php'; // Proxy que tenemos en local
const urlBase = 'http://172.26.0.4/mientornoelega/api-proxy.php'; // Proxy que tenemos en local
let grafica; // Global para Chart.js

// Descripciones de periodos


document.getElementById('fechaSeleccionada').addEventListener('change', cargarDatos);
document.getElementById('tarifaSeleccionada').addEventListener('change', cargarDatos);

async function cargarDatos() {
    const tarifa = document.getElementById('tarifaSeleccionada').value;
    const fecha = document.getElementById('fechaSeleccionada').value;

    if (!tarifa || !fecha) {
        document.getElementById('infoDia').style.display = 'none';
        document.getElementById('bloqueGrafica').style.display = 'none';
        return;
    }

    const url = `${urlBase}?tipo=tarifa&valor=${tarifa}&fecha=${fecha}`;
    try {
        const response = await fetch(url);
        if (!response.ok) throw new Error('Error en la llamada API');

        const datos = await response.json();

        if (!datos.length) {
            alert('No hay datos para esta tarifa y fecha.');
            document.getElementById('infoDia').style.display = 'none';
            document.getElementById('bloqueGrafica').style.display = 'none';
            return;
        }

        const horas = datos.map(dato => dato.hora_compra);
        const precios = datos.map(dato => dato.coste_energia_eurosmwh / 1000); // €/kWh

        const media = precios.reduce((a, b) => a + b, 0) / precios.length;
        const periodo = datos[0].periodo || 'Desconocido';
        
        document.getElementById('mediaPrecio').innerHTML = `Precio Medio del Día: <strong>${media.toFixed(5)} €/kWh</strong>`;
        document.getElementById('infoDia').style.display = 'block';

        const ctx = document.getElementById('graficaCostes').getContext('2d');

        if (grafica) {
            grafica.destroy();
        }

        grafica = new Chart(ctx, {
            type: 'line',
            data: {
                labels: horas.map(h => `H${h.toString().padStart(2, '0')}`),
                datasets: [{
                    label: 'Coste Energía (€/kWh)',
                    data: precios,
                    borderColor: 'rgba(75, 192, 192, 1)',
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    tension: 0.3,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: { title: { display: true, text: 'Hora' }},
                    y: { title: { display: true, text: 'Precio (€/kWh)' }}
                },
                plugins: {
                    legend: { display: true, position: 'top' }
                }
            }
        });

        document.getElementById('bloqueGrafica').style.display = 'block';

    } catch (error) {
        console.error(error);
        alert('Error cargando datos');
    }
}

  // Ocultar automáticamente la alerta después de 4 segundos
  setTimeout(() => {
    const alerta = document.getElementById('alertaGuardado');
    if (alerta) {
      alerta.classList.remove('show'); // Inicia la animación de cierre
      alerta.classList.add('fade');    // Asegura transición
      setTimeout(() => alerta.remove(), 500); // Lo elimina del DOM tras animación
    }
  }, 4000); // 4 segundos

  setTimeout(function() {
    const mensaje = document.getElementById('mensajeExito');
    if (mensaje) {
      mensaje.style.transition = 'opacity 0.5s ease-out';
      mensaje.style.opacity = '0';
      setTimeout(() => mensaje.remove(), 500); // Elimina el elemento del DOM después de difuminarlo
    }
  }, 2000); // 2000 ms = 2 segundos

   // Elimina el parámetro ?mensaje de la URL sin recargar
   if (window.history.replaceState) {
      const url = new URL(window.location);
      url.searchParams.delete('mensaje');
      window.history.replaceState(null, '', url);
    }

    if (window.history.replaceState) {
      const url = new URL(window.location);
      url.searchParams.delete('guardado');
      window.history.replaceState(null, '', url);
    }




</script>


<style>
    .card {
        transition: all 0.3s ease; /* Animación suave */
    }
    .card:hover {
        transform: translateY(-8px); /* Se eleva un poco */
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3); /* Más sombra al pasar */
    }
</style>

</html>
