<?php
// ver_registros.php
$conexion = new mysqli("localhost", "root", "AA11aa11", "origen_clientes");
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

$conteoOrigen = $conexion->query("SELECT origen, COUNT(*) AS total FROM registros_origen GROUP BY origen");


$resultado = $conexion->query("SELECT * FROM registros_origen ORDER BY created_at DESC");


?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Visualización de Registros de Clientes</title>
  
  <link rel="icon" type="image/png" href="img/favi.png">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="position-absolute top-0 end-0 p-3 text-end">
  <h6 class="fw-bold mb-2">📊 Registros por Origen</h6>
  <div class="d-flex flex-wrap justify-content-end gap-2">
    <?php $conteoOrigen->data_seek(0); while ($origen = $conteoOrigen->fetch_assoc()): ?>
      <span class="badge bg-primary">
        <?= ucfirst($origen['origen']) ?>: <?= $origen['total'] ?>
      </span>
    <?php endwhile; ?>
  </div>
</div>


<div class="container mt-5">


<div class="bg-white rounded shadow-sm py-4 px-4 mb-4 border-start border-4 border-warning">
  <h2 class="text-center fs-4 mb-1 fw-bold text-dark">
    <i class="bi bi-folder2-open text-warning me-2 fs-4"></i>
    Visualización de Registros de Clientes
  </h2>
  <p class="text-center text-muted small mt-1">
    Consulta aquí todos los contactos recibidos desde formularios web, redes sociales u otras vías.
  </p>
</div>


<?php if (isset($_GET['eliminado']) && $_GET['eliminado'] === 'ok'): ?>
  <div id="alertaEliminado" class="alert alert-warning alert-dismissible fade show text-center mt-3" role="alert">
    🗑️ Registro eliminado correctamente.
  </div>
<?php endif; ?>

<?php if (isset($_GET['mensaje']) && $_GET['mensaje'] == 'reseña_enviada'): ?>
  <div id="alertaMensaje" class="alert alert-success text-center mt-3">
    📩 Correo de solicitud de reseña enviado correctamente al cliente.
  </div>
<?php endif; ?>


<div class="table-responsive" style="overflow-x: unset;">
  <table id="tablaRegistros" class="table table-bordered table-hover bg-white shadow-sm w-100">
      <thead class="table-primary text-center">
        <tr>
          <!-- <th>ID</th> -->
          <th>Nombre</th>
          <th>Teléfono</th>
          <th>Email</th>
          <th>Origen</th>
          <th>Canal Secundario</th>
          <th>Observaciones</th>
          <th>Fecha</th>
          <th>Acciones</th> <!-- NUEVA COLUMNA -->
        </tr>
      </thead>
      <tbody>
        <?php while ($fila = $resultado->fetch_assoc()): ?>
          <tr>
            <!-- <td><?= $fila['id'] ?></td> -->
            <td><?= htmlspecialchars($fila['nombre']) ?></td>
            <td><?= htmlspecialchars($fila['telefono']) ?></td>
            <td><?= htmlspecialchars($fila['email']) ?></td>
            <td><?= htmlspecialchars($fila['origen']) ?></td>
            <!-- Canal Secundario -->
<td>
<span class="d-inline-block text-nowrap overflow-hidden text-truncate w-100" style="max-width: 140px; cursor:pointer;"
        data-bs-toggle="modal" data-bs-target="#modalTextoLargo"
        data-titulo="Canal Secundario"
        data-texto="<?= htmlspecialchars($fila['canal_secundario']) ?>">
    <?= strlen($fila['canal_secundario']) > 30 ? substr($fila['canal_secundario'], 0, 30) . '...' : $fila['canal_secundario'] ?>
  </span>
</td>

<!-- Observaciones -->
<td>
<span class="d-inline-block text-nowrap overflow-hidden text-truncate w-100" style="max-width: 140px; cursor:pointer;"
        data-bs-toggle="modal" data-bs-target="#modalTextoLargo"
        data-titulo="Observaciones"
        data-texto="<?= htmlspecialchars($fila['observaciones']) ?>">
    <?= strlen($fila['observaciones']) > 30 ? substr($fila['observaciones'], 0, 30) . '...' : $fila['observaciones'] ?>
  </span>
</td>

            <td><?= $fila['created_at'] ?></td>
            <td class="text-center">
            <button 
  class="btn btn-sm btn-danger" 
  data-bs-toggle="modal" 
  data-bs-target="#modalConfirmarEliminar"
  data-id="<?= $fila['id'] ?>"
  data-nombre="<?= htmlspecialchars($fila['nombre']) ?>">
  🗑️ Borrar
</button>
<button 
  class="btn btn-outline-info btn-sm btn-enviar-resena" 
  data-email="<?= htmlspecialchars($fila['email']) ?>" 
  data-nombre="<?= htmlspecialchars($fila['nombre']) ?>"
  data-bs-toggle="modal" 
  data-bs-target="#modalConfirmarEnvio">
  📩 Enviar Reseña
</button>



</td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>


  



  <div class="text-center mt-4">
    <a href="index.php" class="btn btn-secondary">⬅ Volver al Panel Principal</a>
  </div>
</div>
<div class="mt-5"></div>

<footer class="position-fixed bottom-0 start-0 end-0 bg-white border-top shadow-lg" style="z-index:1050;">
  <div class="container py-3">
    <h5 class="text-center fw-bold mb-2">
      ⭐ Opiniones de Clientes sobre <span class="text-primary">Elega Energía</span>
    </h5>

    <p class="text-center text-muted mb-3 small">
      Descubre lo que opinan nuestros clientes y accede directamente a nuestra <strong>ficha de empresa en Google</strong>
      con reseñas <strong>reales y verificadas</strong>.
    </p>

    <div class="text-center mb-2">
      <a href="https://www.google.com/search?q=Elega+Energ%C3%ADa+Rese%C3%B1as"
         target="_blank"
         class="btn btn-success btn-sm px-4">
        📍 Ver ficha y reseñas en Google
      </a>
    </div>

    <div class="text-center">
      <img src="https://www.gstatic.com/images/branding/product/2x/google_my_business_64dp.png"
           alt="Logo de Google My Business"
           width="40" height="40"
           class="rounded shadow-sm"
           loading="lazy">
      <p class="text-muted small mt-2 mb-0">
        Opiniones verificadas en <strong>Google My Business</strong>
      </p>
    </div>
  </div>
</footer>



<!-- Modal para ver texto completo -->
<!-- Modal para ver texto completo con scroll -->
<div class="modal fade" id="modalTextoLargo" tabindex="-1" aria-labelledby="modalTextoLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title" id="modalTextoLabel">Texto completo</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body" style="max-height: 400px; overflow-y: auto; overflow-x: auto;">
        <pre id="contenidoTextoLargo" class="text-dark mb-0" style="white-space: pre-wrap; word-break: break-word;"></pre>
      </div>
    </div>
  </div>
</div>


<!-- Modal confirmación de borrado -->
<div class="modal fade" id="modalConfirmarEliminar" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content rounded-4 shadow-sm">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">¿Confirmar eliminación?</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <p>¿Seguro que deseas eliminar el registro de <strong id="nombreRegistroEliminar"></strong>?</p>
      </div>
      <div class="modal-footer">
        <form method="POST" action="borrar_registro.php">
          <input type="hidden" name="id" id="idRegistroEliminar">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-danger">Eliminar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal Confirmar Envío -->
<div class="modal fade" id="modalConfirmarEnvio" tabindex="-1" aria-labelledby="modalConfirmarLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content rounded-3 shadow">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title" id="modalConfirmarLabel">
          <i class="bi bi-send-check-fill me-2"></i> Confirmar envío
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body text-center">
        <p>¿Estás seguro de que deseas enviar un correo solicitando una reseña a:</p>
        <h6 id="modalNombre" class="fw-bold mb-2 text-primary"></h6>
        <p id="modalEmail" class="small text-muted mb-0"></p>
      </div>
      <div class="modal-footer">
        <a id="btnConfirmarEnvio" href="#" class="btn btn-success">Sí, enviar</a>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </div>
  </div>
</div>





<!-- Scripts de DataTables -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.0/dist/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<!-- Traducción al español -->
<script>
  $(document).ready(function () {
    $('#tablaRegistros').DataTable({
        autoWidth: false, // desactiva el ancho automático
        scrollX: false,   // desactiva scroll horizontal
      language: {
        "decimal":        "",
        "emptyTable":     "No hay datos disponibles en la tabla",
        "info":           "Mostrando _START_ a _END_ de _TOTAL_ registros",
        "infoEmpty":      "Mostrando 0 a 0 de 0 registros",
        "infoFiltered":   "(filtrado de un total de _MAX_ registros)",
        "infoPostFix":    "",
        "thousands":      ",",
        "lengthMenu":     "Mostrar _MENU_ registros",
        "loadingRecords": "Cargando...",
        "processing":     "Procesando...",
        "search":         "Buscar:",
        "zeroRecords":    "No se encontraron resultados",
        "paginate": {
            "first":      "Primero",
            "last":       "Último",
            "next":       "Siguiente",
            "previous":   "Anterior"
        },
        "aria": {
            "sortAscending":  ": Activar para ordenar ascendente",
            "sortDescending": ": Activar para ordenar descendente"
        }
      },
      pageLength: 10
    });
  });

  setTimeout(() => {
    const alerta = document.getElementById('alertaEliminado');
    if (alerta) {
      alerta.classList.remove('show');
      alerta.classList.add('fade');
      setTimeout(() => alerta.remove(), 500);
    }
  }, 4000);



  setTimeout(() => {
    const alerta = document.getElementById('alertaMensaje');
    if (alerta) {
      alerta.classList.remove('show');
      alerta.classList.add('fade');
      setTimeout(() => alerta.remove(), 500);
    }
  }, 4000);


  const modalTexto = document.getElementById('modalTextoLargo');
modalTexto.addEventListener('show.bs.modal', function (event) {
  const trigger = event.relatedTarget;
  const titulo = trigger.getAttribute('data-titulo') || "Texto completo";
  const texto = trigger.getAttribute('data-texto') || "";

  modalTexto.querySelector('.modal-title').textContent = titulo;
  modalTexto.querySelector('#contenidoTextoLargo').textContent = texto;
});


  const modalEliminar = document.getElementById('modalConfirmarEliminar');
modalEliminar.addEventListener('show.bs.modal', function (event) {
  const button = event.relatedTarget;
  const id = button.getAttribute('data-id');
  const nombre = button.getAttribute('data-nombre');
  modalEliminar.querySelector('#idRegistroEliminar').value = id;
  modalEliminar.querySelector('#nombreRegistroEliminar').textContent = nombre;
});

  // Si hay un mensaje de eliminado, limpiamos el parámetro tras 2 segundos
  window.addEventListener("DOMContentLoaded", () => {
    const alerta = document.getElementById('alertaEliminado');
    if (alerta) {
      setTimeout(() => {
        const url = new URL(window.location.href);
        url.searchParams.delete("eliminado");
        window.history.replaceState({}, document.title, url.pathname);
      }, 2000); // o al hacer clic en cerrar
    }
  });

    // Elimina el parámetro ?mensaje de la URL sin recargar
    if (window.history.replaceState) {
      const url = new URL(window.location);
      url.searchParams.delete('mensaje');
      window.history.replaceState(null, '', url);
    }

  document.addEventListener("DOMContentLoaded", function () {
    const modal = document.getElementById("modalConfirmarEnvio");
    const nombreElem = document.getElementById("modalNombre");
    const emailElem = document.getElementById("modalEmail");
    const btnConfirmar = document.getElementById("btnConfirmarEnvio");

    document.querySelectorAll(".btn-enviar-resena").forEach(button => {
      button.addEventListener("click", function () {
        const nombre = this.getAttribute("data-nombre");
        const email = this.getAttribute("data-email");
        nombreElem.textContent = nombre;
        emailElem.textContent = email;

        const url = `enviar_reseña.php?email=${encodeURIComponent(email)}&nombre=${encodeURIComponent(nombre)}`;
        btnConfirmar.setAttribute("href", url);
      });
    });
  });


</script>

<style>

body {
  padding-bottom: 170px; /* deja espacio visible para el footer fijo */
}
  table td, table th {
    vertical-align: middle;
    white-space: nowrap;
  }

  .table td span {
    max-width: 140px;
    display: inline-block;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  .modal .modal-body p {
    white-space: break-word;
    margin-bottom: 0;
  }
  .badge {
    border-radius: 12px;
  }
</style>



</body>
</html>
